package com.android.mobile.dependencies;

import com.android.mobile.ApplicationContext;
import com.android.mobile.PlayerActivity;
import com.android.mobile.dependencies.component.ApplicationComponent;
import com.android.mobile.ui.ScalableCardView;
import com.android.mobile.ui.fragments.ChangeSerialFragment;
import com.android.mobile.ui.fragments.ChannelsFragment;
import com.android.mobile.ui.fragments.CheckSerialFragment;
import com.android.mobile.ui.fragments.MenuFragment;
import com.android.mobile.ui.fragments.SignInFragment;
import com.android.mobile.ui.fragments.SignUpFragment;


public final class Injector {

    private static ApplicationComponent component;

    static {
        component = ApplicationContext.getComponent();
    }

    public static void inject(SignInFragment signInFragment) {
        component.inject(signInFragment);
    }

    public static void inject(ChangeSerialFragment changeSerialFragment) {
        component.inject(changeSerialFragment);
    }

    public static void inject(SignUpFragment signUpFragment) {
        component.inject(signUpFragment);
    }

    public static void inject(ChannelsFragment channelsFragment) {
        component.inject(channelsFragment);
    }

    public static void inject(PlayerActivity playerActivity) {
        component.inject(playerActivity);
    }

    public static void inject(ScalableCardView scalableCardView) {
        component.inject(scalableCardView);
    }

    public static void inject(MenuFragment menuFragment) {
        component.inject(menuFragment);
    }

    public static void inject(CheckSerialFragment checkSerialFragment) {
        component.inject(checkSerialFragment);
    }
}
