package com.android.mobile.database.model;

import android.os.Parcel;
import android.os.Parcelable;

import com.google.gson.Gson;
import com.google.gson.annotations.SerializedName;

import org.greenrobot.greendao.annotation.Entity;
import org.greenrobot.greendao.annotation.Id;
import org.greenrobot.greendao.annotation.Index;
import org.greenrobot.greendao.annotation.Property;
import org.greenrobot.greendao.annotation.Generated;


@Entity(nameInDb = "channels", indexes = {@Index(value = "title DESC", unique = true)})
public class ChannelRecord implements Parcelable {

    @Id(autoincrement = true)
    private Long id;
    @SerializedName("title") @Property(nameInDb = "title")
    private String title;
    @SerializedName("category") @Property(nameInDb = "category")
    private String category;
    @SerializedName("url") @Property(nameInDb = "url")
    private String url;
    @SerializedName("bg_image") @Property(nameInDb = "bg_image")
    private String bgImage;

    public ChannelRecord() {
    }

    public ChannelRecord(String title, String category, String url, String bgImage) {
        this.title = title;
        this.category = category;
        this.url = url;
        this.bgImage = bgImage;
    }

    protected ChannelRecord(Parcel in) {
        this.title = in.readString();
        this.category = in.readString();
        this.url = in.readString();
        this.bgImage = in.readString();
    }

    @Generated(hash = 1905863218)
    public ChannelRecord(Long id, String title, String category, String url, String bgImage) {
        this.id = id;
        this.title = title;
        this.category = category;
        this.url = url;
        this.bgImage = bgImage;
    }

    @Override
    public void writeToParcel(Parcel dest, int flags) {
        dest.writeString(title);
        dest.writeString(category);
        dest.writeString(url);
        dest.writeString(bgImage);
    }

    @Override
    public int describeContents() {
        return 0;
    }

    public static final Creator<ChannelRecord> CREATOR = new Creator<ChannelRecord>() {
        @Override
        public ChannelRecord createFromParcel(Parcel in) {
            return new ChannelRecord(in);
        }

        @Override
        public ChannelRecord[] newArray(int size) {
            return new ChannelRecord[size];
        }
    };

    public String getTitle() {
        return title == null ? "" : title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public String getCategory() {
        return category;
    }

    public void setCategory(String category) {
        this.category = category;
    }

    public String getUrl() {
        return url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public String getBgImage() {
        return bgImage;
    }

    public void setBgImage(String bgImage) {
        this.bgImage = bgImage;
    }

    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    @Override
    public String toString() {
        return new Gson().toJson(this);
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) return true;
        if (!(o instanceof ChannelRecord)) return false;

        ChannelRecord channel = (ChannelRecord) o;

        if (getTitle() != null ? !getTitle().equals(channel.getTitle()) : channel.getTitle() != null)
            return false;
        if (getCategory() != null ? !getCategory().equals(channel.getCategory()) : channel.getCategory() != null)
            return false;
        if (getUrl() != null ? !getUrl().equals(channel.getUrl()) : channel.getUrl() != null)
            return false;
        return getBgImage() != null ? getBgImage().equals(channel.getBgImage()) : channel.getBgImage() == null;

    }

    @Override
    public int hashCode() {
        int result = getTitle() != null ? getTitle().hashCode() : 0;
        result = 31 * result + (getCategory() != null ? getCategory().hashCode() : 0);
        result = 31 * result + (getUrl() != null ? getUrl().hashCode() : 0);
        result = 31 * result + (getBgImage() != null ? getBgImage().hashCode() : 0);
        return result;
    }

}
