package com.android.mobile.api.controller;

import com.android.mobile.api.STBResponse;
import com.android.mobile.api.retrofit.RetrofitCallback;
import com.android.mobile.api.retrofit.service.AccountService;

import java.io.IOException;
import java.util.Map;

import retrofit2.Call;
import retrofit2.Response;
import retrofit2.Retrofit;


public class AccountController {

    private static final String TAG = AccountController.class.getSimpleName();

    private Callback mCallback;
    private AccountService mAccountService;

    public AccountController(Retrofit retrofit) {
        mAccountService = retrofit.create(AccountService.class);
    }

    public void setCallback(Callback mCallback) {
        this.mCallback = mCallback;
    }

    public void signIn(Map<String, String> params) {

        if (mCallback != null) {
            mCallback.onRun();
        }

        mAccountService.signIn(params).enqueue(new retrofit2.Callback<STBResponse>() {
            @Override
            public void onResponse(Call<STBResponse> call, Response<STBResponse> response) {
                if (response.isSuccessful()) {
                    if (mCallback != null) {
                        mCallback.onSuccess(response.body());
                    }
                } else {
                    if (mCallback != null) {
                        try {
                            mCallback.onFailure(new IOException(response.errorBody().string()));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void onFailure(Call<STBResponse> call, Throwable t) {
                if (mCallback != null) {
                    mCallback.onFailure(t);
                }
            }
        });
    }

    public void signUp(Map<String, String> params) {

        if (mCallback != null) {
            mCallback.onRun();
        }

        mAccountService.signUp(params).enqueue(new retrofit2.Callback<STBResponse>() {
            @Override
            public void onResponse(Call<STBResponse> call, Response<STBResponse> response) {
                if (response.isSuccessful()) {
                    if (mCallback != null) {
                        mCallback.onSuccess(response.body());
                    }
                } else {
                    if (mCallback != null) {
                        try {
                            mCallback.onFailure(new IOException(response.errorBody().string()));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void onFailure(Call<STBResponse> call, Throwable t) {
                if (mCallback != null) {
                    mCallback.onFailure(t);
                }
            }
        });
    }

    public void signOut() {

        if (mCallback != null) {
            mCallback.onRun();
        }

        mAccountService.signOut().enqueue(new retrofit2.Callback<STBResponse>() {
            @Override
            public void onResponse(Call<STBResponse> call, Response<STBResponse> response) {
                if (response.isSuccessful()) {
                    if (mCallback != null) {
                        mCallback.onSuccess(response.body());
                    }
                } else {
                    if (mCallback != null) {
                        try {
                            mCallback.onFailure(new IOException(response.errorBody().string()));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void onFailure(Call<STBResponse> call, Throwable t) {
                if (mCallback != null) {
                    mCallback.onFailure(t);
                }
            }
        });
    }

    public void setUserIdentifier(Map<String, String> params) {

        if (mCallback != null) {
            mCallback.onRun();
        }

        mAccountService.setUserIdentifier(params).enqueue(new retrofit2.Callback<STBResponse>() {
            @Override
            public void onResponse(Call<STBResponse> call, Response<STBResponse> response) {
                if (response.isSuccessful()) {
                    if (mCallback != null) {
                        mCallback.onSuccess(response.body());
                    }
                } else {
                    if (mCallback != null) {
                        try {
                            mCallback.onFailure(new IOException(response.errorBody().string()));
                        } catch (IOException e) {
                            e.printStackTrace();
                        }
                    }
                }
            }

            @Override
            public void onFailure(Call<STBResponse> call, Throwable t) {
                if (mCallback != null) {
                    mCallback.onFailure(t);
                }
            }
        });
    }

    public interface Callback extends RetrofitCallback {
        void onRun();
        void onSuccess(STBResponse response);
        void onFailure(Throwable throwable);
    }

}
