package com.android.mobile.api;

import com.google.gson.annotations.SerializedName;

import java.util.Map;

public final class STBResponse {

    @SerializedName("status_code") private String statusCode;
    @SerializedName("data") private Map<String, String> data;
    @SerializedName("details") private String details;

    private STBResponse(Builder builder) {
        statusCode = builder.statusCode;
        data = builder.data;
        details = builder.details;
    }

    public String getStatusCode() {
        return statusCode;
    }

    public Map<String, String> getData() {
        return data;
    }

    public String getDetails() {
        return details;
    }

    public boolean isSuccessful() {
        return statusCode.equals("200");
    }

    @Override
    public String toString() {
        return "STBResponse{" +
                "statusCode='" + statusCode + '\'' +
                ", data=" + data +
                ", details='" + details + '\'' +
                '}';
    }

    public static final class Builder {

        private String statusCode;
        private Map<String, String> data;
        private String details;

        public Builder() {
        }

        public Builder statusCode(String statusCode) {
            this.statusCode = statusCode;
            return this;
        }

        public Builder data(Map<String, String> data) {
            this.data = data;
            return this;
        }

        public Builder details(String details) {
            this.details = details;
            return this;
        }

        public STBResponse build() {
            return new STBResponse(this);
        }
    }
}
