package com.android.mobile;

import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v4.app.Fragment;
import android.support.v7.app.AppCompatActivity;
import android.widget.ImageView;

import com.android.mobile.ui.fragments.CheckSerialFragment;
import com.android.mobile.ui.fragments.DeviceNotRegisteredFragment;
import com.android.mobile.util.APIUtil;
import com.android.mobile.util.Preferences;
import com.android.mobile.util.ViewUtil;


public class IdentifyUserActivity extends AppCompatActivity  {

    private static final String TAG = IdentifyUserActivity.class.getSimpleName();

    public static final String STATUS = "status";

    public static final int DEVICE_NOT_REGISTERED = 0;
    public static final int CHECK_SERIAL = 1;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        setContentView(R.layout.identify_user_activity);

        int status = getIntent().getIntExtra(STATUS, -1);

        ViewUtil.setImageDrawable(this,
                (ImageView) findViewById(R.id.logotype),
                APIUtil.getISPLogo(Preferences.getUserIsp(this)));

        if (status != -1) {
            getSupportFragmentManager()
                    .beginTransaction()
                    .setCustomAnimations(android.R.anim.fade_in, android.R.anim.fade_out)
                    .add(R.id.container, getFragment(status))
                    .commit();
        }

    }

    private Fragment getFragment(int status) {
        switch (status) {
            case CHECK_SERIAL:
                return CheckSerialFragment.newInstance(null);
            case DEVICE_NOT_REGISTERED:
                return DeviceNotRegisteredFragment.newInstance(null);
        }
        return null;
    }

}
