package com.android.mobile;

import android.content.Intent;
import android.os.Build;
import android.os.Bundle;
import android.support.annotation.Nullable;
import android.support.v7.app.AppCompatActivity;
import android.util.Log;
import android.view.WindowManager;

import com.android.mobile.util.Preferences;

public abstract class BaseActivity extends AppCompatActivity {

    private static final String TAG = BaseActivity.class.getSimpleName();

    private static final int STATE_NORMAL = -1;
    private static final int STATE_UNDEFINED = 0;
    private static final int STATE_NOT_REGISTERED = 1;

    @Override
    protected void onCreate(@Nullable Bundle savedInstanceState) {
        getWindow().setFlags(WindowManager.LayoutParams.FLAG_FULLSCREEN, WindowManager.LayoutParams.FLAG_FULLSCREEN);
        setApplicationRoute();
        super.onCreate(savedInstanceState);
    }

    private void setApplicationRoute() {
        int state = getApplicationState();
        Log.d(TAG, "App state: " + state);
        Intent intent = getRouteIntent(state);
        if (intent != null) {
            startActivity(intent);
            finish();
        }
    }

    private Intent getRouteIntent(int state) {
        Intent intent = new Intent(this, IdentifyUserActivity.class);
        switch (state) {
            case STATE_UNDEFINED:
                return intent.putExtra(IdentifyUserActivity.STATUS, IdentifyUserActivity.CHECK_SERIAL);
            case STATE_NOT_REGISTERED:
                return intent.putExtra(IdentifyUserActivity.STATUS, IdentifyUserActivity.DEVICE_NOT_REGISTERED);
        }
        return null;
    }

    private int getApplicationState() {
        if (isUndefined()) {
            return STATE_UNDEFINED;
        } else if (!isRegistered()) {
            return STATE_NOT_REGISTERED;
        }
        return STATE_NORMAL;
    }

    private boolean hasIdentifier() {
        return Preferences.getUserIdentifier(this) != null
                && !Preferences.getUserIdentifier(this).equals(Build.UNKNOWN);
    }

    private boolean isRegistered() {
        return Preferences.getUserLogin(this) != null &&
                Preferences.getUserPassword(this) != null;
    }

    private boolean isUndefined() {
        return !hasIdentifier() && !isRegistered();
    }

}
