#ifndef TRANSCEIVER_CLIENT_H
#define TRANSCEIVER_CLIENT_H
#include <netinet/in.h> // sockaddr_in
#include <iostream> // std::cerr
#include <arpa/inet.h> //atoi

#define BUF_SIZE 65535
#define PACKET_SIZE 188


enum ClientType {
    RECEIVER,
    SENDER
};

class Client {
    protected:
        ClientType type = RECEIVER;

        char buffer[BUF_SIZE];

        // READER
        int readSocket;
        int readIntPort;
        char * readPort;
        char * readAddress;
        int initReadSocket();
        // TODO(s1z): add readInterface;

        // SENDER
        int sendSocket;
        int sendIntPort;
        char * sendPort;
        char * sendAddress;
        int initSendSocket();
        // TODO(s1z): add sendInterface;

        struct sockaddr_in tcpAddress;
        struct sockaddr_in udpAddress;
        struct ip_mreqn mcastContext;
    public:
        ClientType getType();
        void start();
};


#endif //TRANSCEIVER_CLIENT_H
