#include "Sender.h"


Sender::Sender(char* address,
               char* rPort,
               char* sPort):readAddress(address),
                            readPort(rPort),
                            sendPort(sPort),
                            readIntPort(atoi(rPort)),
                            readIntPort(atoi(rPort)),
                            type(SENDER){
    resetAddresses();
    initReadSocket();
    initSendSocket();
}


void Sender::resetAddresses() {
    memset((char *) &tcpAddress, 0, sizeof(tcpAddress));
    memset((char *) &udpAddress, 0, sizeof(udpAddress));
}


int Sender::Client::initReadSocket() {
    /*
     * Read socket is the udp mcast socket.
     * We listen 238.1.2.3:1234 for example from ANY source IP
     */
    this->mcastContext.imr_multiaddr.s_addr = inet_addr(readAddress);
    this->mcastContext.imr_address.s_addr = INADDR_ANY;

    this->udpAddress.sin_family = AF_INET;
    this->udpAddress.sin_port = htons(readIntPort);
    this->udpAddress.sin_addr.s_addr = inet_addr(readAddress);

    readSocket = socket(AF_INET, SOCK_DGRAM, 0);
    return readSocket;
}


int Sender::Client::initSendSocket() {
    /*
     * We open port an wait for connection.
     */
    // TODO(s1z): Add device binding
    tcpAddress.sin_family = AF_INET;
    tcpAddress.sin_addr.s_addr = htonl(INADDR_ANY);
    tcpAddress.sin_port = htons(sendIntPort);

    sendSocket = socket(AF_INET, SOCK_STREAM, 0);
    return sendSocket;
}
